<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="ltr">

<head>
    <!-- META DATA -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="manoar">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'BD Travel') }}</title>
    <!-- FAVICON -->
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('favicon.ico')}}" />

    <!-- STYLE CSS -->
    <link href="{{asset('backend/plugins/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" />
    <link href="{{asset('backend/css/style.css')}}" rel="stylesheet" />
    <link href="{{asset('backend/css/dark-style.css')}}" rel="stylesheet" />
    <link href="{{asset('backend/css/transparent-style.css')}}" rel="stylesheet">
    <link href="{{asset('backend/css/skin-modes.css')}}" rel="stylesheet" />

    <!--- FONT-ICONS CSS -->
    <link href="{{asset('backend/css/icons.css')}}" rel="stylesheet" />

    {{-- Cute Alert --}}
    <link href="{{asset('vendor/cute-alert/cute-alert.css')}}" rel="stylesheet" />

    <!-- COLOR SKIN CSS -->
    <link id="theme" rel="stylesheet" type="text/css" media="all" href="{{asset('backend/colors/color1.css')}}" />
    @vite('resources/js/app.js')
    @stack('style')

    @isset($style)
    {{ $style }}
    @endisset
</head>

<body class="app sidebar-mini ltr">

    <!-- GLOBAL-LOADER -->
    <div id="global-loader">
        <img src="{{asset('backend/images/loader.svg')}}" class="loader-img" alt="Loader">
    </div>
    <!-- /GLOBAL-LOADER -->

    <!-- PAGE -->
    <div class="page">
        <div class="page-main">

            <!-- app-Header -->
            @include('layouts.navigation')
            <!-- /app-Header -->

            <!--APP-SIDEBAR-->
            @include('layouts.include.sidebar')
            <!--app-content open-->
            <div class="main-content app-content mt-0">
                <div class="side-app">

                    <!-- CONTAINER -->
                    <div class="main-container container-fluid">
                        <!-- Page Heading -->
                        @isset($header)
                        <!-- PAGE-HEADER -->
                        <div class="page-header">
                            <h1 class="page-title">
                                {{ $header }}
                            </h1>
                        </div>
                        <!-- PAGE-HEADER END -->
                        @endisset

                        <!-- Page Content -->
                        <main>
                            {{ $slot }}
                        </main>

                    </div>
                    <!-- CONTAINER CLOSED -->

                </div>
            </div>
            <!--app-content closed-->
        </div>

        <!-- FOOTER -->
        <footer class="footer">
            <div class="container">
                <div class="row align-items-center flex-row-reverse">
                    <div class="col-md-12 col-sm-12 text-center">
                        Copyright &copy; <span id="year"></span> <a href="javascript:void(0)">BD Travel</a>  All rights reserved.
                    </div>
                </div>
            </div>
        </footer>
        <!-- FOOTER CLOSED -->

        <!-- Sidebar-right -->
        {{-- @include('layouts.include.right-sidebar') --}}
        <!--/Sidebar-right-->
        @include('layouts.include.modal')

    </div>

    <!-- BACK-TO-TOP -->
    <a href="#top" id="back-to-top"><i class="fa fa-angle-up"></i></a>

    <!-- JQUERY JS -->
    <script src="{{asset('backend/js/jquery.min.js')}}"></script>

    <!-- BOOTSTRAP JS -->
    <script src="{{asset('backend/plugins/bootstrap/js/popper.min.js')}}"></script>
    <script src="{{asset('backend/plugins/bootstrap/js/bootstrap.min.js')}}"></script>

    <!-- SPARKLINE JS-->
    <script src="{{asset('backend/js/jquery.sparkline.min.js')}}"></script>

    <!-- CHART-CIRCLE JS-->
    <script src="{{asset('backend/js/circle-progress.min.js')}}"></script>

    <!-- C3 CHART JS-->
    <script src="{{asset('backend/plugins/charts-c3/d3.v5.min.js')}}"></script>
    <script src="{{asset('backend/plugins/charts-c3/c3-chart.js')}}"></script>

    <!-- INPUT MASK JS-->
    <script src="{{asset('backend/plugins/input-mask/jquery.mask.min.js')}}"></script>

    <!-- SIDE-MENU JS -->
    <script src="{{asset('backend/plugins/sidemenu/sidemenu.js')}}"></script>

    <!-- SIDEBAR JS -->
    <script src="{{asset('backend/plugins/sidebar/sidebar.js')}}"></script>

    <!-- Perfect SCROLLBAR JS-->
    {{-- <script src="{{asset('backend/plugins/p-scroll/perfect-scrollbar.js')}}"></script>
    <script src="{{asset('backend/plugins/p-scroll/pscroll.js')}}"></script>
    <script src="{{asset('backend/plugins/p-scroll/pscroll-1.js')}}"></script> --}}

    <!-- Color Theme js -->
    <script src="{{asset('backend/js/themeColors.js')}}"></script>

    <!-- Sticky js -->
    <script src="{{asset('backend/js/sticky.js')}}"></script>

    <!-- Cute Alert -->
    <script src="{{asset('vendor/cute-alert/cute-alert.js')}}"></script>

    <!-- CUSTOM JS -->
    <script src="{{asset('backend/js/custom.js')}}"></script>
    @include('layouts.include.alert')
    @stack('script')
    @isset($script)
    {{ $script }}
    @endisset
</body>

</html>
